/**
* Script: angle.js
* Written by: Radnen
* Updated: 12/18/2010
**/

const A_PI = Math.PI;
const A_2PI = Math.PI*2;

/**
* Angle:
*  - Used for easy conversion and basic use.
*  - Ang: optional copy constructor.
**/
function Angle(ang) {

	this.rad = 0;
	this.deg = 0;
	
	if (ang) { this.rad = ang.rad; this.deg = ang.deg; }
	
	// setter has a clamp 0 <= x < 2_PI
	this.__defineSetter__("radians", function(r) {
		this.rad = r;
		this.deg = r / A_PI * 180.0;
		this.clamp();
	});
	
	// setter has a clamp 0 <= x < 360
	this.__defineSetter__("degrees", function(d) {
		this.rad = d / 180.0 * A_PI;
		this.deg = d;
		this.clamp();
	});
	
	this.__defineGetter__("radians", function() { return this.rad; });
	this.__defineGetter__("degrees", function() { return this.deg; });
	
	this.clone = function() {
		return new Angle(this);
	}
	
	// hopefully by always clamping there may not be a need to
	// use a more robust clamp method.
	this.clamp = function() {
		if (this.deg >= 360) this.deg -= 360;
		if (this.deg < 0) this.deg += 360;
		if (this.rad >= A_2PI) this.rad -= A_2PI;
		if (this.rad < 0) this.rad += A_2PI;
	}
}